//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

Item {
    id : alignedFlow

    property int alignment         : Qt.AlignHCenter
    property int cellWidth         : 20
    property int cellHeight        : 20
    property int horizontalSpacing : 0
    property int verticalSpacing   : 0

    readonly property int rowCount : p_.rowCount

    onChildrenChanged : p_.performLayout()
    onWidthChanged : p_.performLayout()
    onCellWidthChanged : p_.performLayout()
    onCellHeightChanged : p_.performLayout()
    onHorizontalSpacingChanged : p_.performLayout()
    onVerticalSpacingChanged : p_.performLayout()
    Component.onCompleted : p_.performLayout()

    QtObject {
        id : p_

        property int rowCount : 0

        function performLayout() {
            var layoutItems = [];

            for (var i = 0; i < children.length; ++i) {
                var child = children[i];
                if (child.width > 0 && child.height > 0)
                    layoutItems.push(child);
            }

            var itemCount = layoutItems.length;
            var maxItemsPerRow = Math.floor(
                       (alignedFlow.width + alignedFlow.horizontalSpacing) /
                       (alignedFlow.cellWidth + alignedFlow.horizontalSpacing));
            var requiredRows =
                    (maxItemsPerRow > 0) ? Math.ceil(itemCount / maxItemsPerRow) : 0;

            p_.rowCount = requiredRows;

            var v = 0, w = 0;
            while (layoutItems.length > 0 && requiredRows > 0) {
                var itemsPerRow = Math.min(
                            maxItemsPerRow,
                            Math.ceil(layoutItems.length / requiredRows));
                var h = 0;

                w = itemsPerRow * alignedFlow.cellWidth +
                        (itemsPerRow - 1) * alignedFlow.horizontalSpacing;

                if (alignedFlow.alignment === Qt.AlignHCenter) {
                    h = parseInt(alignedFlow.width - w) / 2;
                } else if (alignedFlow.alignment === Qt.AlignRight) {
                    h = alignedFlow.width - w;
                }

                for (i = 0; i < itemsPerRow; ++i) {
                    var item = layoutItems.shift();
                    item.x = Math.round(h);
                    item.y = Math.round(v);
                    h += alignedFlow.cellWidth + alignedFlow.horizontalSpacing;
                }
                v += alignedFlow.cellHeight + alignedFlow.verticalSpacing;
                --requiredRows;
            }
            alignedFlow.implicitHeight = v;
            alignedFlow.implicitWidth = w;
        }
    }
}
